package it.unicam.pizzeria4.servizio;

import it.unicam.pizzeria4.util.Course;

public class Portata extends Ordinazione {

	private String note;
	private int quantita;
	private int ordine;
	private Piatto piatto;

	public Portata(Piatto piatto, int quantita) {
		super();
		this.quantita = quantita;
		this.piatto = piatto;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public int getQuantita() {
		return quantita;
	}

	public int getOrdine() {
		return ordine;
	}

	public void setOrdine(int ordine) {
		this.ordine = ordine;
	}

	public Piatto getPiatto() {
		return piatto;
	}

	public void setPiatto(Piatto piatto) {
		this.piatto = piatto;
	}

	@Override
	public String getID() {
		return piatto.getID();
	}

	@Override
	public String getNome() {
		return piatto.getNome();
	}

	@Override
	public Course getTipo() {
		return piatto.getTipo();
	}

	@Override
	public double getPrezzo() {
		return piatto.getPrezzo();
	}

	@Override
	public String getIngredienti() {
		String[] ingredienti = piatto.getIngredienti();
		if (ingredienti.length > 0) {
			String lista = "Ingr: ";
			for (int i = 0; i < ingredienti.length; i++) {
				lista += " " + ingredienti[i];
			}
			return lista;
		}
		return "N.A.";
	}

	@Override
	public String getIntolleranze() {
		return piatto.getIntolleranze();
	}

	@Override
	public void setQuantita(int quantita) {
		this.quantita = quantita;
	}
}
